----------------------------------------------------------------------------
----------------------------------------------------------------------------
--[[
Base code taken from Puuro's Wndrwll shoutouts to UPS!
--]]
----------------------------------------------------------------------------
----------------------------------------------------------------------------

local function iris_mod_internal(str, pn)
	local ps= GAMESTATE:GetPlayerState(pn)
	local pmods= ps:GetPlayerOptionsString('ModsLevel_Song')
	ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
end

local function iris_mod(str)
	for i=1,2 do
		iris_mod_internal(str, 'PlayerNumber_P' .. i)
	end
end

local function iris_init()
	continuousmoment_skewx=0.3
	checked = false
	curmod = 1
	--tipsy, drunk, distant, reverse, flip, 
	mods = {
		{0.1,'*80 500 tipsy'},
		{4,'*5 0 tipsy, *5 20 drunk'},
		{8,'*100 -400 tipsy, *100 reverse'},
		{8.1,'*100 0 tipsy'},
		{9.5,'*100 -400 tipsy, *100 no reverse'},
		{9.6,'*100 0 tipsy'},
		{11,'*100 -400 tipsy, *100 reverse'},
		{11.1,'*100 0 tipsy'},
		{16,'*100 -400 tipsy, *100 no reverse'},
		{16.1,'*100 0 tipsy'},
		{16.75,'*100 -400 tipsy'},
		{16.85,'*100 0 tipsy'},
		{17.5,'*100 -400 tipsy'},
		{17.6,'*100 0 tipsy'},
		{18.25,'*100 -400 tipsy'},
		{18.35,'*100 0 tipsy'},
		{19,'*100 -400 tipsy'},
		{19.1,'*100 0 tipsy'},
		{24,'*5 40 drunk, *0.2 -100 mini'},
		{36,'*10 20 drunk, *100 0 mini'},
		{40,'*40 10 bumpy,*100 100 beat'},
		{53.5,'*200 flip'},
		{54,'*200 no flip'},
		{54.75,'*200 flip'},
		{55.5,'*200 no flip'},
		{69.5,'*200 flip'},
		{70,'*200 no flip'},
		{70.75,'*200 flip'},
		{71.5,'*100 no flip'},
		{74,'*0.3 80 drunk'},
		{84,'*40 10 bumpy,*100 0 beat, *0.2 20 drunk'},
		{91,'*100 -400 tipsy,*100 50 stealth'},
		{91.15,'*20 0 tipsy,*100 no stealth'},
		{98,'*1 boomerang'},
		{98.15,'*0.1 no boomerang'},
		{103,'*0.1 -200 confusion'},
		{104,'*5 0 confusion'},
		{107,'*200 30 mini'},
		{107.5,'*200 0 mini'},
		{112,'*200 -200 drunk'},
		{112.5,'*200 20 drunk'},
		{113.25,'*200 -200 drunk'},
		{113.75,'*200 20 drunk'},
		{118.000,'*2 100 mini'},
		{120.000,'*3 dizzy'},
		{136.0,'*2 30 flip,*2 no reverse'},
		{143.5,'*1 0 flip,*2 no reverse'},
		{150.000,'*0.2 0 mini'},
		{160.0,'*100 -350 drunk'},
		{160.15,'*20 0 drunk'},
		{161.0,'*100 350 drunk'},
		{161.15,'*20 0 drunk'}	,
		{162.0,'*100 -350 tipsy'},
		{162.15,'*20 0 tipsy'},
		{163.0,'*100 350 tipsy'},
		{163.15,'*20 0 tipsy'},		
		{167,'*2 no dizzy'},
		{167.5,'*2 centered'},
		{180.0,'*2 100 drunk'},
		{182.0,'*2 0 drunk'},
		{184.0,'*2 no centered'},
		{185.0,'*100 -350 drunk'},
		{185.15,'*20 0 drunk'},
		{187.0,'*100 350 drunk'},
		{187.15,'*20 0 drunk'},
		{189.0,'*100 -350 tipsy'},
		{189.15,'*20 0 tipsy'},
		{191.0,'*100 350 tipsy'},
		{191.15,'*20 0 tipsy'},
		{193.0,'*100 -350 drunk'},
		{193.15,'*20 0 drunk'},
		{195.0,'*100 350 drunk'},
		{195.15,'*20 0 drunk'},
		{200.0,'*100 -200 tiny, *100 50 bumpy, *100 30 drunk'},
		{200.15,'*5 0 tiny'},
		{203.5,'*100 -200 tiny'},
		{203.65,'*4 0 tiny'},	
		{208.0,'*100 -100 tiny'},
		{208.15,'*2 0 tiny'},		
		{211.5,'*100 -100 tiny'},
		{211.65,'*1 0 tiny'},
		{216,'*100 -400 tipsy,*100 50 stealth'},
		{216.15,'*20 0 tipsy,*100 no stealth'},
		{218,'*100 -400 tipsy,*100 50 stealth'},
		{218.15,'*20 0 tipsy,*100 no stealth'},
		{220,'*100 -400 tipsy,*100 50 stealth'},
		{220.15,'*20 0 tipsy,*100 no stealth'},
		{222,'*100 -400 tipsy,*100 50 stealth'},
		{222.15,'*20 0 tipsy,*100 no stealth'},
		{224,'*100 -400 tipsy,*100 50 stealth'},
		{224.15,'*20 0 tipsy,*100 no stealth'},
		{225,'*100 -400 tipsy,*100 50 stealth'},
		{225.15,'*20 0 tipsy,*100 no stealth'},
		{228,'*100 0 drunk'},
		{232,'*40 10 bumpy,*100 100 beat'},
		{260,'*100 0 beat'},
		{264,'*100 100 beat'},
		{278.5,'*100 0 beat'},
		{280,'*100 20 drunk, *100 -400 tipsy'},
		{280.1,'*100 0 tipsy'},
		{284,'*100 -400 tipsy'},
		{284.1,'*100 0 tipsy'},
		{288,'*100 -400 tipsy'},
		{288.1,'*100 0 tipsy'},
		{289,'*100 -400 tipsy'},
		{289.25,'*100 0 tipsy'},
		{290.5,'*100 -400 tipsy'},
		{290.6,'*100 0 tipsy'},
		{292,'*100 -400 tipsy'},
		{292.1,'*100 0 tipsy'},
		{296,'*100 -400 tipsy, *100 reverse'},
		{296.1,'*100 0 tipsy'},
		{297.5,'*100 -400 tipsy, *100 no reverse'},
		{297.6,'*100 0 tipsy'},
		{299,'*100 -400 tipsy, *100 reverse'},
		{299.1,'*100 0 tipsy'},
		{303,'*100 no reverse'},
		{308.00,'*100 flip'},
	}

	curmessage = 1

	messages = {
		{0,'NoCheating'},		
		{119.9,'PlayersSkew1'},
		{121.9,'PlayersSkew2'},
		{123.9,'PlayersSkew1'},
		{125.9,'PlayersSkew2'},
		{127.9,'PlayersSkew1'},
		{129.9,'PlayersSkew2'},
		{131.9,'PlayersSkew1'},
		{133.9,'PlayersSkew2'},
		{134.9,'PlayersSkew0'},		
		{240.0,'PlayersRot1'},
		{241.25,'PlayersRot2'},
		{242.5,'PlayersRot1'},
		{244,'PlayersRot0'},
		{256.0,'PlayersRot2'},
		{257.25,'PlayersRot1'},
		{258.5,'PlayersRot2'},
		{260,'PlayersRot0'},	
		{272.0,'PlayersRot1'},
		{273.25,'PlayersRot2'},
		{274.5,'PlayersRot1'},
		{276,'PlayersRot0'},
		{310,'Reload'},
	}	
end

local function iris_update()

	if GAMESTATE:GetSongBeat() >= 0.1 and not checked then
	
		if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
			P1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1')
		end
		if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
			P2 = SCREENMAN:GetTopScreen():GetChild('PlayerP2')
		end
		checked = true	
	end

	-- Collect all the mods that will be applied in this frame into one string.
	-- Mod tweening doesn't work correctly if the mods are in seperate commands.
	local mods_this_frame = {}
	local function add_mod(mod_str)
		mods_this_frame[#mods_this_frame+1] = mod_str
	end
	local function execute_mods()
		if #mods_this_frame <= 0 then return end
		local total_mod_str= ""
		for i, ms in ipairs(mods_this_frame) do
			if #total_mod_str > 0 then
				total_mod_str= total_mod_str .. ", "
			end
			total_mod_str= total_mod_str .. ms
		end
		iris_mod(total_mod_str)
	end
	
	while curmod <= #mods and GAMESTATE:GetSongBeat() >= mods[curmod][1] do
		add_mod(mods[curmod][2])
		curmod = curmod+1
	end

	execute_mods()
	
	while curmessage <= #messages and GAMESTATE:GetSongBeat() >= messages[curmessage][1] do
		if messages[curmessage][3] and GAMESTATE:GetSongBeat() >= messages[curmessage][1]+5 then
			curmessage = curmessage+1
		else
			MESSAGEMAN:Broadcast(messages[curmessage][2])
			curmessage = curmessage+1
		end
	end
end

return Def.ActorFrame{
	OnCommand = function(self)
					iris_init()
					self:SetUpdateFunction(iris_update)
				end,
	Def.Quad{
		Name = "I may be sleeping, but I preserve the world.",
		InitCommand = cmd(visible,false),
		OnCommand = cmd(sleep,1000),
	},
	Def.Quad{
		OnCommand= cmd(diffuse,0,0,0,1;diffusealpha,0;zoomto,6,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y),

		PlayersRot1MessageCommand = function(self)
			if P1 then
				P1:rotationz(20)
			end		
			if P2 then
				P2:rotationz(-20)
			end
		end,
		
		PlayersRot2MessageCommand = function(self)
			if P1 then
				P1:rotationz(-20)
			end			
			if P2 then
				P2:rotationz(20)
			end
		end,
		
		PlayersRot0MessageCommand = function(self)
			if P1 then
				P1:rotationz(0)
			end		
			if P2 then
				P2:rotationz(0)
			end
		end,
		
		PlayersSkew1MessageCommand = function(self)
			if P1 then
				P1:smooth(0.10)
				P1:skewx(continuousmoment_skewx)
			end
			if P2 then
				P2:smooth(0.10)
				P2:skewx(-continuousmoment_skewx)
			end
		end,
		
		PlayersSkew2MessageCommand = function(self)
			if P1 then
				P1:smooth(0.10)
				P1:skewx(-continuousmoment_skewx)
			end		
			if P2 then
				P2:smooth(0.10)
				P2:skewx(continuousmoment_skewx)
			end
		end,
		
		PlayersSkew0MessageCommand = function(self)
			if P1 then
				P1:stoptweening()
				P1:smooth(0.10)
				P1:skewx(0)
			end			
			if P2 then
				P2:stoptweening()
				P1:smooth(0.10)
				P2:skewx(0)
			end
		end,
		
		PlayersSkew0SnapMessageCommand = function(self)
			if P1 then
				P1:stoptweening()
				P2:smooth(0.10)
				P1:skewx(0)
			end			
			if P2 then
				P2:stoptweening()
				P2:linear(0)
				P2:skewx(0)
			end
		end,
		
		ReloadMessageCommand = function(self)
			--Haha bad game design go brrrrrrrrr
			if math.random(1, 5) ~= 3 then
				SCREENMAN:SetNewScreen('ScreenGameplay')
			end
		end,
		
		NoCheatingMessageCommand = function(self)
			if GAMESTATE:GetSongOptionsString() == '' then
				rateMod = '1.00'
			else
				rateMod = string.format("%.2f", string.sub(GAMESTATE:GetSongOptionsString(), 1, string.len(GAMESTATE:GetSongOptionsString()) - 6))
			end

			for player in ivalues(GAMESTATE:GetHumanPlayers()) do
				local ps = GAMESTATE:GetPlayerState(player)

				if ps then
					local po = ps:GetPlayerOptions("ModsLevel_Song")

					if po then
						local cmod = po:CMod()
						local mmod = po:MMod()
				  
						if cmod ~= nil or mmod ~= nil then
							local bpms = GAMESTATE:GetCurrentSteps(player):GetDisplayBpms()
							po:XMod((cmod or mmod)/bpms[2]/rateMod)
						end
					end
				end
			end
		end
	}
}